<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
include 'conexao.php';

if (!isset($_SESSION['aluno'])) {
    header("Location: login_aluno.php");
    exit;
}

$aluno_id   = $_SESSION['aluno']['id'];
$turma_id   = $_SESSION['aluno']['turma_id'];
$nome_aluno = $_SESSION['aluno']['nome'] ?? '';
$turma_nome = $_SESSION['aluno']['turma'] ?? '---';
$classe     = $_SESSION['aluno']['classe'] ?? '';

// Buscar trabalhos para a turma
$stmt = $conn->prepare("
    SELECT t.*, d.nome AS disciplina, p.nome AS professor
    FROM trabalhos t
    INNER JOIN disciplinas d ON t.disciplina_id = d.id
    INNER JOIN professores p ON t.professor_id = p.id
    WHERE t.turma_id = ?
    ORDER BY t.data_envio DESC
");
$stmt->bind_param("i", $turma_id);
$stmt->execute();
$trabalhos = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Trabalhos da Turma</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: Arial, sans-serif; background: #f4f6f9; padding: 10px; color: #333; }
    .header { background: #002244; color: white; text-align: center; padding: 15px; font-size: 20px; font-weight: bold; }
    .info { text-align: center; margin: 15px 0; }
    .trabalho {
      background: white; margin-bottom: 15px; padding: 15px; border-radius: 6px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .trabalho h3 { margin: 0 0 5px; color: #003366; }
    .trabalho .desc { margin: 8px 0; }
    .trabalho small { color: #666; }
    .btn {
      display: inline-block; padding: 6px 12px; background: #007BFF; color: white;
      text-decoration: none; border-radius: 4px; font-size: 13px;
    }
    @media (max-width: 600px) {
      .trabalho { font-size: 14px; }
    }
  </style>
</head>
<body>

<div class="header">Trabalhos da Sua Turma</div>

<div class="info">
  <strong>Aluno:</strong> <?= htmlspecialchars($nome_aluno) ?> |
  <strong>Turma:</strong> <?= htmlspecialchars($turma_nome) ?> |
  <strong>Classe:</strong> <?= htmlspecialchars($classe) ?>
</div>

<?php if ($trabalhos->num_rows > 0): ?>
  <?php while ($t = $trabalhos->fetch_assoc()): ?>
    <div class="trabalho">
      <h3><?= htmlspecialchars($t['titulo']) ?></h3>
      <div class="desc"><?= nl2br(htmlspecialchars($t['descricao'])) ?></div>
      <small>
        <strong>Disciplina:</strong> <?= htmlspecialchars($t['disciplina']) ?> |
        <strong>Professor:</strong> <?= htmlspecialchars($t['professor']) ?> |
        <strong>Data:</strong> <?= date('d/m/Y', strtotime($t['data_envio'])) ?>
      </small><br><br>
      
      <?php if (!empty($t['anexo']) && file_exists("uploads_trabalhos/" . $t['anexo'])): ?>
        <a class="btn" href="uploads_trabalhos/<?= urlencode($t['anexo']) ?>" target="_blank">📂 Ver Anexo</a>
      <?php else: ?>
        <span style="color: red;">📁 Sem anexo disponível</span>
      <?php endif; ?>
    </div>
  <?php endwhile; ?>
<?php else: ?>
  <p style="text-align:center;">Nenhum trabalho encontrado para sua turma.</p>
<?php endif; ?>

</body>
</html>
